/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer.message;

import filenet.sim.api.VWScenarioValidationError;
import filenet.sim.toolkit.designer.message.VWSIMValidationToolTip;
import filenet.sim.toolkit.designer.message.images.VWSIMImageLoader;
import filenet.vw.api.VWValidationError;
import filenet.vw.base.VWDebug;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

class VWSIMValidationErrorTypeTableCellRenderer
extends JLabel
implements TableCellRenderer {
    private ImageIcon m_stepIcon = null;
    private ImageIcon m_routeIcon = null;
    private ImageIcon m_milestoneIcon = null;
    private ImageIcon m_dataFieldIcon = null;
    private ImageIcon m_attachmentFieldIcon = null;
    private ImageIcon m_wfGroupFieldIcon = null;
    private ImageIcon m_instructionIcon = null;
    private ImageIcon m_parameterIcon = null;
    private ImageIcon m_generalIcon = null;
    private ImageIcon m_workflowIcon = null;
    private ImageIcon m_resourceIcon = null;
    private ImageIcon m_jobDutyIcon = null;
    private ImageIcon m_shiftIcon = null;

    public VWSIMValidationErrorTypeTableCellRenderer() {
        try {
            this.setOpaque(true);
            this.m_generalIcon = VWSIMImageLoader.createImageIcon("general.gif");
            this.m_workflowIcon = VWSIMImageLoader.createImageIcon("workflow.gif");
            this.m_resourceIcon = VWSIMImageLoader.createImageIcon("resource16.gif");
            this.m_jobDutyIcon = VWSIMImageLoader.createImageIcon("role16.gif");
            this.m_shiftIcon = VWSIMImageLoader.createImageIcon("shift16.gif");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        ImageIcon icon = null;
        VWScenarioValidationError error = (VWScenarioValidationError)value;
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
            this.setForeground(table.getSelectionForeground());
        } else {
            this.setBackground(table.getBackground());
            this.setForeground(table.getForeground());
        }
        if (error != null) {
            int errorType = error.getErrorType();
            if (errorType == 1) {
                VWValidationError wfError = error.getVWValidationError();
                block0 : switch (wfError.getErrorType()) {
                    case 6: {
                        icon = this.m_workflowIcon;
                        break;
                    }
                    case 1: {
                        icon = this.m_stepIcon;
                        break;
                    }
                    case 2: {
                        icon = this.m_routeIcon;
                        break;
                    }
                    case 4: {
                        int fieldType = this.findFieldType(error.getName());
                        switch (fieldType) {
                            case 1: 
                            case 2: 
                            case 4: 
                            case 8: 
                            case 16: {
                                icon = this.m_dataFieldIcon;
                                break block0;
                            }
                            case 32: {
                                icon = this.m_attachmentFieldIcon;
                                break block0;
                            }
                            case 64: {
                                icon = this.m_wfGroupFieldIcon;
                            }
                        }
                        break;
                    }
                    case 7: {
                        icon = this.m_instructionIcon;
                        break;
                    }
                    case 8: {
                        icon = this.m_milestoneIcon;
                        break;
                    }
                    case 3: {
                        icon = this.m_parameterIcon;
                    }
                }
            } else {
                switch (error.getErrorType()) {
                    case 7: {
                        break;
                    }
                    case 3: {
                        icon = this.m_resourceIcon;
                        break;
                    }
                    case 4: {
                        icon = this.m_jobDutyIcon;
                        break;
                    }
                    case 5: {
                        icon = this.m_shiftIcon;
                        break;
                    }
                    case 8: {
                        icon = this.m_workflowIcon;
                        break;
                    }
                    case 6: {
                        icon = this.m_workflowIcon;
                        break;
                    }
                    case 2: {
                        icon = this.m_generalIcon;
                    }
                }
            }
        }
        this.setText(null);
        this.setToolTipText(VWSIMValidationToolTip.createValidationToolTip(error));
        this.setComponentOrientation(table.getComponentOrientation());
        this.setIcon(icon);
        return this;
    }

    private int findFieldType(String fieldName) {
        int fieldType = 1;
        return fieldType;
    }
}

